// 4428CardDlg.cpp : implementation file
//

#include "stdafx.h"
#include "4428Card.h"
#include "4428CardDlg.h"
#include "umfh.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#pragma comment(lib,"umf.lib")

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy4428CardDlg dialog

CMy4428CardDlg::CMy4428CardDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy4428CardDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy4428CardDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	isAuthened=FALSE;
}

void CMy4428CardDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy4428CardDlg)
	DDX_Control(pDX, IDC_LIST1, m_list);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy4428CardDlg, CDialog)
	//{{AFX_MSG_MAP(CMy4428CardDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_BTN_READ, OnBtnRead)
	ON_BN_CLICKED(ID_BTN_INITCOM, OnBtnInitcom)
	ON_BN_CLICKED(ID_BTN_AUTHEN, OnBtnAuthen)
	ON_BN_CLICKED(ID_BTN_WRITE, OnBtnWrite)
	ON_BN_CLICKED(ID_BTN_READPROT, OnBtnReadprot)
	ON_BN_CLICKED(ID_BTN_WRITEPROT, OnBtnWriteprot)
	ON_BN_CLICKED(ID_BTN_CHANGEKEY, OnBtnChangekey)
	ON_BN_CLICKED(ID_BTN_CNTRERR, OnBtnCntrerr)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy4428CardDlg message handlers

BOOL CMy4428CardDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMy4428CardDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMy4428CardDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMy4428CardDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMy4428CardDlg::OnBtnRead() 
{
	// TODO: Add your control notification handler code here
	m_list.ResetContent();

	unsigned char rbuffer[1000];
	unsigned char showrbuffer[2000];
	memset(rbuffer,0,1000);
	memset(showrbuffer,0,2000);
	int rlen=900;
	unsigned char Addr=16;
	if(!fw_read_4428(icdev,Addr,rbuffer,rlen))
	{
		m_list.AddString("Read data success");
		m_list.AddString("DATA: ");
		hex_a(showrbuffer,rbuffer,2*rlen);
//		m_list.AddString((char *)showrbuffer);
		showMsg((char *)showrbuffer);
		return;
	}
	m_list.AddString("Read data failed");

}

void CMy4428CardDlg::OnBtnInitcom() 
{
	// TODO: Add your control notification handler code here
	icdev=fw_init(100,119200);
	if(icdev>0)
	{
		if(icdev!=0x7c)
		{
			MessageBox("Open port success");
			return;
		}
	}
	
	AfxMessageBox("Open port failed");
	
}

void CMy4428CardDlg::OnBtnAuthen() 
{
	// TODO: Add your control notification handler code here
	m_list.ResetContent();
	unsigned char keybuffer[8]={0xff,0xff};
	if(!fw_authentikey_4428(icdev,keybuffer))
	{
		m_list.AddString("Password verify success");

		isAuthened=TRUE;//set isAuthened true

		return;
	}
	m_list.AddString("Password verify failed");


}

void CMy4428CardDlg::OnBtnWrite() 
{
	// TODO: Add your control notification handler code here
	m_list.ResetContent();

	unsigned char wbuffer[1024];
	unsigned int wAddr=40;
//	memset(wbuffer,0,1000);
	for(int i=0;i<1000;i++)
	{
		wbuffer[i]=(unsigned char)i;
	}
//	wbuffer[0]='A';
//	wbuffer[1]='B';
//	wbuffer[2]='C';
//	wbuffer[3]='D';

	int wlen=900;
	if(!isAuthened)
	{
		AfxMessageBox("Please verify password first");
		return;
	}
	if(!fw_write_4428(icdev,wAddr,wbuffer,wlen))
	{
		m_list.AddString("Write data success");
	}
	else
	{
		m_list.AddString("Write data failed");
	}
}

void CMy4428CardDlg::OnBtnReadprot() 
{
	// TODO: Add your control notification handler code here
	m_list.ResetContent();

	unsigned char rbuffer[255];
	unsigned char rstrbuffer[255];
	memset(rbuffer,0,255);
	memset(rstrbuffer,0,255);

	if(!fw_getProtectData_4428(icdev,29,rbuffer,3))
	{
		m_list.AddString("Read protection bits success");
		CString str;

		hex_a(rstrbuffer,rbuffer,2*3);

		str.Format("Data: %s",rstrbuffer);
		m_list.AddString(str);
		return;
	}
	m_list.AddString("Read protection bits failed");
}

void CMy4428CardDlg::OnBtnWriteprot() 
{
	// TODO: Add your control notification handler code here

	m_list.ResetContent();
	unsigned char sbuf[4]={0xff,0xff,0xff};

	if(!fw_setProtectData_4428(icdev,29,sbuf,3))
	{
		m_list.AddString("Write protection success");
		return;
	}
	m_list.AddString("Write protection failed");


}

void CMy4428CardDlg::OnBtnChangekey() 
{
	// TODO: Add your control notification handler code here
	m_list.ResetContent();
	unsigned char keybuffer[8]={0xff,0x11};
	if(!fw_changkey_4428(icdev,keybuffer))
	{
		m_list.AddString("Password changed success");

		return;
	}
	m_list.AddString("Password changed failed");
}

void CMy4428CardDlg::OnBtnCntrerr() 
{
	// TODO: Add your control notification handler code here
	m_list.ResetContent();
	unsigned char cntError;
	if(!fw_cntReadError_4428(icdev,&cntError))
	{
		m_list.AddString("Test success");
		CString str;
		str.Format("Error-Count: %d",(int)cntError);
		m_list.AddString(str);

		return;
	}
	m_list.AddString("Test failed");
}

void CMy4428CardDlg::showMsg(char *data)
{
	int datalen=strlen(data);
	int showtime=datalen/32+1;
	for(int i=0;i<showtime;i++)
	{
		char *tempbuf;
		tempbuf=(char *)malloc(32*sizeof(char));
		char *singshow;
		singshow=tempbuf;
		for(int j=0;j<32;j++)
		{
			*(tempbuf++)=*(data++);
		}
		m_list.AddString(singshow);

		free(singshow);

	}

}
